<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#assign hasDupCheckEntity=false>
<#list sys.getAllPSDataEntities() as dataEntity>
    <#assign isDupCheck=isDupCheckEntity(dataEntity)>
    <#if isDupCheck>
        <#assign hasDupCheckEntity=true>
        <#break>
    </#if>
</#list>
<#if hasDupCheckEntity>
package ${pub.getPKGCodeName()}.util.aspect;

import lombok.extern.slf4j.Slf4j;
import ${pub.getPKGCodeName()}.util.annotation.DEField;
import ${pub.getPKGCodeName()}.util.enums.DupCheck;
import ${pub.getPKGCodeName()}.util.errors.BadRequestAlertException;
import ${pub.getPKGCodeName()}.util.filter.QueryFilter;
import ${pub.getPKGCodeName()}.util.filter.SearchContextBase;
import ${pub.getPKGCodeName()}.util.helper.DEFieldCacheMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.data.domain.Page;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import java.util.Map;

/**
 * 属性重复值检查切面
 */
@Aspect
@Component
@Slf4j
public class DupCheckAspect {

    private final ExpressionParser parser = new SpelExpressionParser();

    <#list sys.getAllPSDataEntities() as dataEntity>
        <#assign isDupCheck=isDupCheckEntity(dataEntity)>
        <#assign hasDefaultDS=checkDefaultDS(dataEntity)>
        <#if isDupCheck && hasDefaultDS>
     /**
     * 实体[${dataEntity.codeName}]
     *
     * @param point
     */
    @AfterReturning(value = "(execution(* ${pub.getPKGCodeName()}.core.*.service.*${dataEntity.codeName}*.create*(..))||execution(* ${pub.getPKGCodeName()}.core.*.service.*${dataEntity.codeName}*.update*(..))||execution(* ${pub.getPKGCodeName()}.core.*.service.*${dataEntity.codeName}*.save*(..))  ) && !execution(* ${pub.getPKGCodeName()}.core.es.service.*.create*(..)) && !execution(* ${pub.getPKGCodeName()}.core.es.service.*.update*(..)) && !execution(* ${pub.getPKGCodeName()}.core.es.service.*.save*(..)) ")
    public void check${dataEntity.codeName?lower_case?cap_first}(JoinPoint point) {
        check(point, "search${dataEntity.getDefaultPSDEDataSet().codeName}");
    }
        </#if>
    </#list>

    /**
     * 实体属性重复值检查
     * @param point 切点
     * @param defaultDS 实体默认数据集名称
     */
    private void check(JoinPoint point, String defaultDS) {
        Object[] args = point.getArgs();
        if (args.length > 0) {
            Object entity = args[0];
            Object service = point.getTarget();
            Map<String, DEField> deFields = DEFieldCacheMap.getDEFields(entity.getClass());
            for (Map.Entry<String, DEField> deField : deFields.entrySet()) {
                String fieldName = deField.getKey();
                DEField fieldAnnotation = deField.getValue();
                DupCheck dupCheck = fieldAnnotation.dupCheck();
                String dupCheckField=fieldAnnotation.dupCheckField();
                if (dupCheck == DupCheck.ALL) {
                    Object newValue =getDEFieldValue(entity,fieldName);
                    //获取searchContext
                    EvaluationContext searchContextCtx = new StandardEvaluationContext();
                    searchContextCtx.setVariable("service", service);
                    Expression searchContextExp = parser.parseExpression("#service.getSearchContext()");
                    SearchContextBase searchContext = searchContextExp.getValue(searchContextCtx, SearchContextBase.class);

                    //设置检查属性值
                    QueryFilter filter = new QueryFilter();
                    setValue(entity,filter,fieldName,newValue);

                    //设定重复值检查范围
                    if(!StringUtils.isEmpty(dupCheckField)){
                        Object dupFieldValue=getDEFieldValue(entity,dupCheckField);
                        setValue(entity,filter,dupCheckField,dupFieldValue);
                    }
                    searchContext.setFilter(filter);
                    //使用当前值到数据库中进行查询，判断是否重复
                    EvaluationContext oldValueMappingCtx = new StandardEvaluationContext();
                    oldValueMappingCtx.setVariable("service", service);
                    oldValueMappingCtx.setVariable("searchContext", searchContext);
                    Expression oldValueMappingExp = parser.parseExpression(String.format("#service.%s(#searchContext)",defaultDS));
                    Page oldData = oldValueMappingExp.getValue(oldValueMappingCtx, Page.class);
                    if (!ObjectUtils.isEmpty(oldData) && !ObjectUtils.isEmpty(oldData.getContent()) && oldData.getContent().size() > 1) {
                        throw new BadRequestAlertException(String.format("数据保存失败，属性[%s]:值[%s]已存在!", fieldName, newValue), "DupCheckAspect", "DupCheck");
                    }
                }
            }
        }
    }

    /**
     * 获取实体属性值
     * @param entity
     * @param fieldName
     * @return
     */
    private Object getDEFieldValue(Object entity, String fieldName){
        EvaluationContext exMappingCtx = new StandardEvaluationContext();
        exMappingCtx.setVariable("entity", entity);
        Expression esMappingExp = parser.parseExpression(String.format("#entity.get(\"%s\")", fieldName));
        return esMappingExp.getValue(exMappingCtx);
    }

    /**
     * 设置filter
     * @param entity
     * @param filter
     * @param value
     */
    private void setValue(Object entity , QueryFilter filter, String fieldName, Object value){
        if(ObjectUtils.isEmpty(value))
            filter.isnull(DEFieldCacheMap.getFieldColumnName(entity.getClass(), fieldName));
        else
            filter.eq(DEFieldCacheMap.getFieldColumnName(entity.getClass(), fieldName),value);
    }
}
</#if>

<#comment>判断属性是否配置了重复值检查</#comment>
<#function isDupCheckEntity dataEntity>
    <#assign dupCheck=false>
    <#if dataEntity.getAllPSDEFields()??>
        <#list dataEntity.getAllPSDEFields() as defield>
            <#if defield.getDupCheckMode?? && defield.getDupCheckMode()?? && defield.getDupCheckMode()=='ALL'>
                <#assign dupCheck=true>
                <#break>
            </#if>
        </#list>
    </#if>
<#return dupCheck>
</#function>

<#comment>判断实体中是否配置了默认数据集</#comment>
<#function checkDefaultDS dataEntity>
    <#assign defaultDS=false>
    <#if dataEntity.getDefaultPSDEDataSet?? && dataEntity.getDefaultPSDEDataSet()?? && dataEntity.getDefaultPSDEDataSet().getPSDEDataQueries()??>
        <#list dataEntity.getDefaultPSDEDataSet().getPSDEDataQueries() as dq>
            <#assign defaultDS=true>
            <#break>
        </#list>
    </#if>
    <#return defaultDS>
</#function>